#include "MTFileList.h"

#include "MTSimpleResource.h"
#include "MTAKEVViewer.h"
#include "MTAKOTViewer.h"
#include "MTBINAViewer.h"
#include "MTCBPIViewer.h"
#include "MTCBPMViewer.h"
#include "MTCONSViewer.h"
#include "MTCRSAViewer.h"
#include "MTCJBOViewer.h"
#include "MTDOORViewer.h"
#include "MTDPgeViewer.h"
#include "MTENVPViewer.h"
#include "MTFILMViewer.h"
#include "MTHPgeViewer.h"
#include "MTIDXAViewer.h"
#include "MTIGHHViewer.h"
#include "MTIGPAViewer.h"
#include "MTIGPGViewer.h"
#include "MTIGSAViewer.h"
#include "MTIGStViewer.h"
#include "MTImptViewer.h"
#include "MTIPgeViewer.h"
#include "MTKeyIViewer.h"
#include "MTM3GAViewer.h"
#include "MTM3GMViewer.h"
#include "MTMtrlViewer.h"
#include "MTOBANViewer.h"
#include "MTOFGAViewer.h"
#include "MTONCCViewer.h"
#include "MTONCVViewer.h"
#include "MTONFAViewer.h"
#include "MTONGSViewer.h"
#include "MTONIAViewer.h"
#include "MTONLDViewer.h"
#include "MTONLVViewer.h"
#include "MTONOAViewer.h"
#include "MTONVLViewer.h"
#include "MTOSBDViewer.h"
#include "MTOTLFViewer.h"
#include "MTPNTAViewer.h"
#include "MTPSpcViewer.h"
#include "MTPSpLViewer.h"
#include "MTPSUIViewer.h"
#include "MTSNDDViewer.h"
#include "MTStNAViewer.h"
#include "MTSUBTViewer.h"
#include "MTTRACViewer.h"
#include "MTTRAMViewer.h"
#include "MTTRASViewer.h"
#include "MTTRBSViewer.h"
#include "MTTRCMViewer.h"
#include "MTTRGAViewer.h"
#include "MTTRGEViewer.h"
#include "MTTRIAViewer.h"
#include "MTTRIGViewer.h"
#include "MTTRMAViewer.h"
#include "MTTRSCViewer.h"
#include "MTTRTAViewer.h"
#include "MTTSFFViewer.h"
#include "MTTSFLViewer.h"
#include "MTTSGAViewer.h"
#include "MTTStrViewer.h"
#include "MTTURRViewer.h"
#include "MTTXANViewer.h"
#include "MTTXCAViewer.h"
#include "MTTXMAViewer.h"
#include "MTTXMBViewer.h"
#include "MTTXMPViewer.h"
#include "MTVCRAViewer.h"
#include "MTWMCLViewer.h"
#include "MTWMDDViewer.h"
#include "MTWMMBViewer.h"
#include "MTWMM_Viewer.h"
#include "MTWPgeViewer.h"

#include "MTApplication.h"
#include "MTInfoWindow.h"
#include "MTExceptions.h"

const UInt32				MTFileList::kFileListWidth = 200;
const UInt32				MTFileList::kFileListElementHeight = 12;
MTFontStyle					MTFileList::kListFontStyle("\pMonaco", 9);
MTInfoWindowDataTemplate	MTFileList::kFileInfoTemplate =
{
	8,
	
	{
		{	"Index" },
		{	"Type" },
		{	"Start Offset" },
		{	"Name Offset" },
		{	"Size" },
		{	"Flags" },
		{	"Name" },
		{	"ID" }
	}
};

//	MTFileList::MTFileList()
//	
//	constructor
MTFileList::MTFileList()
{
	theFile = nil;
}

//	MTFileList::~MTFileList()
//	
//	destructor
MTFileList::~MTFileList()
{
	delete theFile;
}

//	void MTFileList::HandleKeyEvent(EventRecord * theEvent, UInt8 charCode, UInt8 keyCode, EventModifiers modifiers)
//	
//	handles key events
void MTFileList::HandleKeyEvent(EventRecord * theEvent, UInt8 charCode, UInt8 keyCode, EventModifiers modifiers)
{
	if(AutoHandleKeyEvent(theEvent, charCode, keyCode, modifiers))
	{
		
	}
}

//	void MTFileList::ObjectUpdated(UInt32 type, UInt32 object)
//	
//	handles object updated events
//	
//	type = object type
//	object = object id
void MTFileList::ObjectUpdated(UInt32 type, UInt32 object)
{
	#pragma unused (type)
	#pragma unused (object)
}

//	void MTFileList::ObjectDeleted(UInt32 type, UInt32 object)
//	
//	handles object deleted events
//	
//	type = object type
//	object = object id
void MTFileList::ObjectDeleted(UInt32 type, UInt32 object)
{
	#pragma unused (type)
	#pragma unused (object)
}

//	void MTFileList::RecieveMessage(UInt32 messageType, UInt32 messageData)
//	
//	recieves messages
//	
//	messageType = message type
//	messageData = message data
void MTFileList::RecieveMessage(UInt32 messageType, UInt32 messageData)
{
	#pragma unused (messageData)
	
	switch(messageType)
	{
		case 'EXPT':
			theFile->ExportFileByIdx(selection);
			break;
		
		case 'INFO':
			SpawnFileInfoWindow(selection);
			break;
		
		case 'IMPT':
			theFile->ImportFileByIdx(selection);
			break;
		
		case 'TDMP':
			theFile->TextDump();
			break;
	}
}

UInt8 MTFileList::SupportsMessage(UInt32 messageType, UInt32 messageData)
{
	#pragma unused (messageData)
	
	switch(messageType)
	{
		case 'EXPT':
		case 'IMPT':
		case 'INFO':
		case 'TDMP':
			return 1;
	}
	
	return 0;
}

void MTFileList::OpenViewerWindow(UInt32 selection)
{
	MTWindow	* theWindow = CreateViewerWindow(selection);
	
	if(theWindow)
	{
		gTheApp->AttachWindow(theWindow);
	}
}

void MTFileList::OpenViewerWindowEX(UInt32 type, char * name, UInt32 idx, UInt8 base, UInt32 offset, UInt32 size)
{
	UInt8	* buf = nil;
	
	if(!theFile)
		return;
	
	try
	{
		switch(base)
		{
			case kSourceFileBase:
				buf = theFile->LoadBase(offset, size);
				break;
			
			case kSourceFileRaw:
				buf = theFile->LoadRaw(offset, size);
				break;
			
			case kSourceFileSegment:
				buf = theFile->LoadSegment(offset, size);
				break;
		}
		
		if(buf)
		{
			MTWindow	* theWindow = CreateViewerWindowEX(buf, type, name, idx, base, offset, size);
			
			if(theWindow)
			{
				gTheApp->AttachWindow(theWindow);
			}
			else
			{
				DisposePtr((Ptr)buf);
			}
		}
	}
	catch(MTException err)
	{
		err.DoErrorDialog();
	}
}

MTWindow * MTFileList::CreateViewerWindow(UInt32 selection)
{
	return CreateViewerWindowEX(
			theFile->LoadFileByIdx(selection),
			theFile->fileList[selection].type,
			(char *)theFile->fileList[selection].name.c_str(), // *hack*
			selection,
			kSourceFileBase,
			theFile->fileList[selection].start,
			theFile->fileList[selection].size);
}

MTWindow * MTFileList::CreateViewerWindowEX(UInt8 * buf, UInt32 type, char * name, UInt32 idx, UInt8 base, UInt32 offset, UInt32 size)
{
	if(!buf)
		return nil;
	
	MTWindow	* theWindow = nil;
	
	try
	{
		MTViewer	* viewer = CreateViewer(type);
		
		if(viewer)
		{
			MTWindow	* window = dynamic_cast <MTWindow *>(viewer);
			
			if(window)
			{
				window->SetOwner(this);
				
				viewer->SetType(type);
				viewer->SetName(name);
				viewer->SetIdx(idx);
				
				viewer->SetSourceFile(base);
				viewer->SetSourceOffset(offset);
				viewer->SetSourceSize(size);
				
				viewer->ParseData(buf, size);
				
				theWindow = window;
			}
		}
	}
	catch(MTException err)
	{
		err.DoErrorDialog();
		
		return nil;
	}
	
	return theWindow;
}

//	void MTFileList::DrawElement(UInt32 id, SInt32 x, SInt32 y, UInt32 flags)
//	
//	draws a list element
//	
//	id = element id
//	x = x position
//	y = y position
//	flags = draw flags
void MTFileList::DrawElement(UInt32 id, SInt32 x, SInt32 y, UInt32 flags)
{
	char		buf[4096];
	UInt32		length;
	Rect		where;
	SInt32		width;
	MTFontSaver	fontSaver;
	
	GetWindowBounds(theWindow, kWindowContentRgn, &where);
	width = where.right - where.left - kScrollBarSize;
	
	if(id >= theFile->fileList.size())
		return;
	
	if(theFile->fileList[id].name.empty())
		std::sprintf(buf, "%.4s", &theFile->fileList[id].type);
	else
		std::sprintf(buf, "%.4s %s", &theFile->fileList[id].type, theFile->fileList[id].name.c_str());
	
	kListFontStyle.SetCurrent();
	
	if(HasViewer(theFile->fileList[id].type))
		RGBForeColor(&kBlackColor);
	else
		RGBForeColor(&kGrayColor);
	
	if(flags & kListItemSelectedFlag)
		TextMode(notSrcCopy);
	
	length = std::strlen(buf);
	
	while((TextWidth(buf, 0, length) > width) && length)
		length--;
	
	MoveTo(x + 3, y + 10);
	DrawText(buf, 0, length);
}

//	void MTFileList::HandleListDoubleClick(UInt32 selection)
//	
//	handles double clicks in the list
//	
//	selection = double click index
void MTFileList::HandleListDoubleClick(UInt32 selection)
{
	OpenViewerWindow(selection);
}

//	void MTFileList::GetWindowName(StringPtr theString)
//	
//	gets window name
//	
//	theString = pointer to buffer (recieves p-string)
void MTFileList::GetWindowName(StringPtr theString)
{
	char	buf[256];
	
	std::sprintf(buf, "File List: %#s", theFile->baseFile.name);
	
	CopyCStringToPascal(buf, theString);
}

//	void MTFileList::SpawnFileInfoWindow(UInt32 selection)
//	
//	creates and attaches an info window
//	
//	selection = file index
void MTFileList::SpawnFileInfoWindow(UInt32 selection)
{
	if(selection >= GetListLength())
		return;
	
	MTInfoWindow	* window = new MTInfoWindow;
	char			buf[256];
	
	window->SetOwner(this);
	window->AttachDataTemplate(&kFileInfoTemplate);
	
	std::sprintf(buf, "%d", selection);
	window->SetEntryData(0, buf, 0);
	
	std::sprintf(buf, "%.4s", &theFile->fileList[selection].type);
	window->SetEntryData(1, buf, 0);
	
	std::sprintf(buf, "%.8X", theFile->fileList[selection].start);
	window->SetEntryData(2, buf, 0);
	
	std::sprintf(buf, "%.8X", theFile->fileList[selection].nameOffset);
	window->SetEntryData(3, buf, 0);
	
	std::sprintf(buf, "%.8X", theFile->fileList[selection].size);
	window->SetEntryData(4, buf, 0);
	
	std::sprintf(buf, "%.8X", theFile->fileList[selection].flags);
	window->SetEntryData(5, buf, 0);
	
	window->SetEntryData(6, theFile->fileList[selection].name.c_str(), 0);
	
	std::sprintf(buf, "%.8X", theFile->fileList[selection].id);
	window->SetEntryData(7, buf, 0);
	
	if(theFile->fileList[selection].name.empty())
		std::sprintf(buf, "%.4s #%d", &theFile->fileList[selection].type, selection);
	else
		std::sprintf(buf, "%.4s %s", &theFile->fileList[selection].type, theFile->fileList[selection].name.c_str());
	
	window->SetOwnerName(buf);
	
	window->RecalculateListSpacing();
	
	gTheApp->AttachWindow(window);
	
	window->HandleUpdateEvent();
}

//	MTViewer * MTFileList::CreateViewer(UInt32 type)
//	
//	returns a viewer for a type
//	
//	type = target type
//	returns viewer (nil on failure)
MTViewer * MTFileList::CreateViewer(UInt32 type)
{
	switch(type)
	{
		case 'TXMP':	return new MTTXMPViewer;
		case 'OSBD':	return new MTOSBDViewer;
		case 'BINA':	return new MTBINAViewer;
		case 'ONLD':	return new MTONLDViewer;
		case 'SNDD':	return new MTSNDDViewer;
		case 'TStr':	return new MTTStrViewer;
		case 'TXAN':	return new MTTXANViewer;
		case 'SUBT':	return new MTSUBTViewer;
		case 'ONCV':	return new MTONCVViewer;
		case 'ONVL':	return new MTONVLViewer;
		case 'TXMB':	return new MTTXMBViewer;
		case 'IGSt':	return new MTIGStViewer;
		case 'DPge':	return new MTDPgeViewer;
		case 'IGSA':	return new MTIGSAViewer;
		case 'IGPG':	return new MTIGPGViewer;
		case 'IPge':	return new MTIPgeViewer;
		case 'PSpc':	return new MTPSpcViewer;
		case 'PSUI':	return new MTPSUIViewer;
		case 'PSpL':	return new MTPSpLViewer;
		case 'WMCL':	return new MTWMCLViewer;
		case 'WMDD':	return new MTWMDDViewer;
		case 'M3GM':	return new MTM3GMViewer;
		case 'IDXA':	return new MTIDXAViewer;
		case 'VCRA':	return new MTVCRAViewer;
		case 'PNTA':	return new MTPNTAViewer;
		case 'TXCA':	return new MTTXCAViewer;
		case 'StNA':	return new MTStNAViewer;
		case 'WMM_':	return new MTWMM_Viewer;
		case 'WMMB':	return new MTWMMBViewer;
		case 'TURR':	return new MTTURRViewer;
		case 'Mtrl':	return new MTMtrlViewer;
		case 'Impt':	return new MTImptViewer;
		case 'ONGS':	return new MTONGSViewer;
		case 'IGHH':	return new MTIGHHViewer;
		case 'KeyI':	return new MTKeyIViewer;
		case 'HPge':	return new MTHPgeViewer;
		case 'WPge':	return new MTWPgeViewer;
		case 'TRAM':	return new MTTRAMViewer;
		case 'TSFF':	return new MTTSFFViewer;
		case 'TRIG':	return new MTTRIGViewer;
		case 'OBAN':	return new MTOBANViewer;
		case 'TRGE':	return new MTTRGEViewer;
		case 'OFGA':	return new MTOFGAViewer;
		case 'CONS':	return new MTCONSViewer;
		case 'DOOR':	return new MTDOORViewer;
		case 'ONLV':	return new MTONLVViewer;
		case 'AKEV':	return new MTAKEVViewer;
		case 'TRMA':	return new MTTRMAViewer;
		case 'CBPM':	return new MTCBPMViewer;
		case 'CBPI':	return new MTCBPIViewer;
		case 'ONCC':	return new MTONCCViewer;
		case 'TRCM':	return new MTTRCMViewer;
		case 'TSFL':	return new MTTSFLViewer;
		case 'TSGA':	return new MTTSGAViewer;
		case 'TRGA':	return new MTTRGAViewer;
		case 'TRBS':	return new MTTRBSViewer;
		case 'TRTA':	return new MTTRTAViewer;
		case 'ONOA':	return new MTONOAViewer;
		case 'TXMA':	return new MTTXMAViewer;
		case 'FILM':	return new MTFILMViewer;
		case 'CRSA':	return new MTCRSAViewer;
		case 'AKOT':	return new MTAKOTViewer;
		case 'OTLF':	return new MTOTLFViewer;
		case 'M3GA':	return new MTM3GAViewer;
		case 'TRIA':	return new MTTRIAViewer;
		case 'ONFA':	return new MTONFAViewer;
		case 'ENVP':	return new MTENVPViewer;
		case 'TRAC':	return new MTTRACViewer;
		case 'TRAS':	return new MTTRASViewer;
		case 'TRSC':	return new MTTRSCViewer;
		case 'IGPA':	return new MTIGPAViewer;
		case 'ONIA':	return new MTONIAViewer;
		case 'CJBO':	return new MTCJBOViewer;
	}
	
	return nil;
}

UInt8 MTFileList::HasViewer(UInt32 type)
{
	// yeah, so there's a better way. this works, I'll make it better later
	// heh.. later.. *cough*
	
	switch(type)
	{
		case 'TXMP':
		case 'OSBD':
		case 'BINA':
		case 'ONLD':
		case 'SNDD':
		case 'TStr':
		case 'TXAN':
		case 'SUBT':
		case 'ONCV':
		case 'ONVL':
		case 'TXMB':
		case 'IGSt':
		case 'DPge':
		case 'IGSA':
		case 'IGPG':
		case 'IPge':
		case 'PSpc':
		case 'PSUI':
		case 'PSpL':
		case 'WMCL':
		case 'WMDD':
		case 'M3GM':
		case 'IDXA':
		case 'VCRA':
		case 'PNTA':
		case 'TXCA':
		case 'StNA':
		case 'WMM_':
		case 'WMMB':
		case 'TURR':
		case 'Mtrl':
		case 'Impt':
		case 'ONGS':
		case 'IGHH':
		case 'KeyI':
		case 'HPge':
		case 'WPge':
		case 'TRAM':
		case 'TSFF':
		case 'TRIG':
		case 'OBAN':
		case 'TRGE':
		case 'OFGA':
		case 'CONS':
		case 'DOOR':
		case 'ONLV':
		case 'AKEV':
		case 'TRMA':
		case 'CBPM':
		case 'CBPI':
		case 'ONCC':
		case 'TRCM':
		case 'TSFL':
		case 'TSGA':
		case 'TRGA':
		case 'TRBS':
		case 'TRTA':
		case 'ONOA':
		case 'TXMA':
		case 'FILM':
		case 'CRSA':
		case 'AKOT':
		case 'OTLF':
		case 'M3GA':
		case 'TRIA':
		case 'ONFA':
		case 'ENVP':
		case 'TRAC':
		case 'TRAS':
		case 'TRSC':
		case 'IGPA':
		case 'ONIA':
			return 1;

//		case 'CJBO':	not in base file
	}
	
	return 0;
}
